﻿using System;

namespace gov.va.med.VBECS.Communication.Protocols
{
    internal class ProtocolManager
    {
        private ProtocolManager() { }

        static readonly Object LocatorLock = new object();
        private IProtocolFactory _protocolFactory;
        private static volatile ProtocolManager _internalInstance;

        public static ProtocolManager Instance()
        {
            if (_internalInstance == null)
            {
                lock (LocatorLock)
                {
                    // in case of a race scenario ... check again
                    if (_internalInstance == null)
                    {
                        _internalInstance = new ProtocolManager();
                    }
                }
            }
            return _internalInstance;
        }

        public IProtocolFactory ProtocolFactory
        {
            get
            {
                // If protocol factory is not assigned via Spring.NET, return default protocol factory.
                return _protocolFactory ?? new RawDataProtocolFactory();
            }
// ReSharper disable UnusedMember.Local
// This setter is assigned outside (by Spring.NET)
            private set { _protocolFactory = value; }
// ReSharper restore UnusedMember.Local
        }
    }
}